/*------------------------------------------------------------------------------*
 * File Name:MatObjHeadersDlg.c/h	 											*
 * Creation: Hong 05/18/10														*
 * Purpose: Main OC code for Matrix Object Headers Dialog						*
 * Copyright (c) Originlab Corp. 2010-2018										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Bill 07/14/2010 ORG-552-S1 BETTER_INDICATION_FOR_ACTIVE_MATRIX               *
 *------------------------------------------------------------------------------*/

#ifndef _MAT_OBJ_HEADERS_DLG_H
#define _MAT_OBJ_HEADERS_DLG_H

class MatObjHeadersDlg : public ResizeDialog
{
public:
	MatObjHeadersDlg(MatrixLayer& ml);
	~MatObjHeadersDlg();
	
	virtual int	DoModalEx(HWND hParent);
	
protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_SIZE(OnResize)
	ON_READY(OnReady)
	//ON_DESTROY(OnDestroy)
	
	ON_OK(OnOK)

	ON_EN_CHANGE(IDC_ROW_SIZE, OnEditRowSize)
	ON_EN_CHANGE(IDC_COL_SIZE, OnEditColSize)
	
	ON_EN_CHANGE(IDC_AXIS_X_FIRST, OnEditXFirst)
	ON_EN_CHANGE(IDC_AXIS_X_LAST, OnEditXLast)
	ON_EN_CHANGE(IDC_AXIS_Y_FIRST, OnEditYFirst)
	ON_EN_CHANGE(IDC_AXIS_Y_LAST, OnEditYLast)
	
	ON_EN_CHANGE(IDC_AXIS_LONGNAME, OnEditXYLongName)
	ON_EN_CHANGE(IDC_AXIS_UNIT, OnEditXYUnit)
	ON_EN_CHANGE(IDC_AXIS_COMMENT, OnEditXYComment)
	
	ON_TAB_SEL_CHANGE(IDC_TAB_AXES, OnAxesTabChange)
	
	ON_GRID_AFTER_EDIT(IDC_GRID_Z_AXIS, OnGridAfterEdit)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_GRID_Z_AXIS, OnGridBeforeMouseDown)
EVENTS_END

protected:
	BOOL	OnInitDialog();
	BOOL	OnResize(int nType, int cx, int cy);
	BOOL 	OnReady();
	BOOL 	OnDestroy();
	
	BOOL	OnOK();
	BOOL	AddUserParameter();
	
	BOOL 	OnEditRowSize(Control ctrl);
	BOOL 	OnEditColSize(Control ctrl);
	BOOL 	OnEditDimSize(Control ctrl, TreeNode& trNode);
	
	BOOL 	OnEditXFirst(Control ctrl);
	BOOL 	OnEditXLast(Control ctrl);
	BOOL 	OnEditYFirst(Control ctrl);
	BOOL 	OnEditYLast(Control ctrl);
	BOOL 	OnEditXYMapping(Control ctrl, TreeNode& trNode);
	
	BOOL 	OnEditXYLongName(Control ctrl);
	BOOL 	OnEditXYUnit(Control ctrl);
	BOOL 	OnEditXYComment(Control ctrl);
	BOOL 	OnEditXYHeaders(Control ctrl, TreeNode& trNode);
	
	BOOL	OnAxesTabChange(Control cntrl);


	void	OnGridAfterEdit(Control flxControl, int nRow, int nCol);
	void 	OnGridBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	
	int		GetLabelType(int nRow);
	vector<int>		GetLabelTypes();
	
	void	UpdateGridCellToHeader(int nRow, int nCol);
	
	int		CheckUserSettings();	///Sophy 7/13/2010 ORG-131-P21 MORE_WORK_ON_CHECK_USER_INPUT
		
private:
	bool	isYAxisActived();
	void	updateSharedCtrlValues(bool bYAxisActived);
	int		getNumUserDefineParameters(vector<string>* pvsNames = NULL);
	TreeNode	getLabelNode(int nType);
	
	void	ShowParameterRows(bool bShow);
	
	void	updateControlsOnTabChange(int nCurSel);
	
	void 	setChanged(TreeNode& trNode);
	
	/// Bill 07/14/2010 ORG-552-S1 BETTER_INDICATION_FOR_ACTIVE_MATRIX
	void	goToActiveMatrixColumn();
	/// End BETTER_INDICATION_FOR_ACTIVE_MATRIX
	
private:
	MatrixLayer		m_ml;
	GridControl		m_gridZ;
	TabControl		m_tabCtrl;
	
	Tree			m_trTheme;
	
	bool			m_bIsChanged;
	/// Bill 07/14/2010 ORG-552-S1 BETTER_INDICATION_FOR_ACTIVE_MATRIX
	bool			m_bFirstTimeOpenZHeader;
	/// End BETTER_INDICATION_FOR_ACTIVE_MATRIX
};

#endif //_MAT_OBJ_HEADERS_DLG_H
